<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CamaraController extends Controller
{
    public function index()
    {
        return view('admin.camaras.index', [
            'pageTitle' => 'Cámaras de Seguridad - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.camaras.create', [
            'pageTitle' => 'Nueva Cámara - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.camaras.index')
            ->with('success', 'Cámara agregada');
    }
    
    public function show($id)
    {
        return view('admin.camaras.show', [
            'pageTitle' => 'Detalle Cámara - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.camaras.edit', [
            'pageTitle' => 'Editar Cámara - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.camaras.index')
            ->with('success', 'Cámara actualizada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Cámara eliminada');
    }
}
