<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Condominio;
use Illuminate\Http\Request;

class CondominioController extends Controller
{
    public function index()
    {
        return view('admin.superadmin.condominios.index', [
            'pageTitle' => 'Condominios - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.superadmin.condominios.create', [
            'pageTitle' => 'Nuevo Condominio - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('superadmin.condominios.index')
            ->with('success', 'Condominio creado exitosamente');
    }
    
    public function show($id)
    {
        return view('admin.superadmin.condominios.show', [
            'pageTitle' => 'Detalle Condominio - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.superadmin.condominios.edit', [
            'pageTitle' => 'Editar Condominio - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('superadmin.condominios.index')
            ->with('success', 'Condominio actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Condominio eliminado');
    }
    
    public function backup($id)
    {
        return back()->with('success', 'Backup realizado');
    }
    
    public function suspend($id)
    {
        return back()->with('success', 'Condominio suspendido');
    }
    
    public function activate($id)
    {
        return back()->with('success', 'Condominio activado');
    }
}
