<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SecurityController extends Controller
{
    public function index()
    {
        return view('admin.accesos.index', [
            'pageTitle' => 'Control de Accesos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.accesos.create', [
            'pageTitle' => 'Nuevo Acceso - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.accesos.index')
            ->with('success', 'Acceso registrado');
    }
    
    public function show($id)
    {
        return view('admin.accesos.show', [
            'pageTitle' => 'Detalle Acceso - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.accesos.edit', [
            'pageTitle' => 'Editar Acceso - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.accesos.index')
            ->with('success', 'Acceso actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Acceso eliminado');
    }
}
