<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
    {
        return view('admin.users.index', [
            'pageTitle' => 'Usuarios - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.users.create', [
            'pageTitle' => 'Nuevo Usuario - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.users.index')
            ->with('success', 'Usuario creado');
    }
    
    public function show($id)
    {
        return view('admin.users.show', [
            'pageTitle' => 'Detalle Usuario - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.users.edit', [
            'pageTitle' => 'Editar Usuario - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.users.index')
            ->with('success', 'Usuario actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Usuario eliminado');
    }
    
    public function approve($id)
    {
        return back()->with('success', 'Usuario aprobado');
    }
    
    public function reject($id)
    {
        return back()->with('success', 'Usuario rechazado');
    }
    
    public function generateToken($id)
    {
        return back()->with('success', 'Token generado: URB-' . strtoupper(bin2hex(random_bytes(4))));
    }
}
