<?php

namespace App\Http\Controllers\Resident;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function index()
    {
        return view('resident.payments.index', [
            'pageTitle' => 'Mis Pagos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('resident.payments.create', [
            'pageTitle' => 'Nuevo Pago - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('resident.pagos')
            ->with('success', 'Pago registrado');
    }
    
    public function uploadProof(Request $request, $id)
    {
        return back()->with('success', 'Comprobante subido');
    }
    
    public function history()
    {
        return view('resident.payments.history', [
            'pageTitle' => 'Historial de Pagos - UrbanOSS'
        ]);
    }
}
