<?php
namespace App\Http\Controllers\Security;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AccessController extends Controller
{
    public function index()
    {
        return view('security.accesos.index', [
            'pageTitle' => 'Registro de Accesos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('security.accesos.create', [
            'pageTitle' => 'Nuevo Acceso - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('security.accesos.index')
            ->with('success', 'Acceso registrado');
    }
    
    public function show($id)
    {
        return view('security.accesos.show', [
            'pageTitle' => 'Detalle Acceso - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('security.accesos.edit', [
            'pageTitle' => 'Editar Acceso - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('security.accesos.index')
            ->with('success', 'Acceso actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Acceso eliminado');
    }
    
    public function checkout($id)
    {
        return back()->with('success', 'Check-out registrado');
    }
    
    public function quickRegister()
    {
        return view('security.accesos.quick', [
            'pageTitle' => 'Registro Rápido - UrbanOSS'
        ]);
    }
    
    public function storeQuick(Request $request)
    {
        return redirect()->route('security.accesos.index')
            ->with('success', 'Acceso rápido registrado');
    }
}
