<?php

namespace App\Http\Controllers\Security;

use App\Http\Controllers\Controller;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        return view('security.dashboard.index', [
            'pageTitle' => 'Dashboard Seguridad - UrbanOSS'
        ]);
    }
    
    public function residentes()
    {
        return view('security.residentes.index', [
            'pageTitle' => 'Lista de Residentes - UrbanOSS'
        ]);
    }
    
    public function residenteDetail($id)
    {
        return view('security.residentes.show', [
            'pageTitle' => 'Detalle Residentes - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function cameras()
    {
        return view('security.cameras.index', [
            'pageTitle' => 'Cámaras de Seguridad - UrbanOSS'
        ]);
    }
    
    public function cameraView($id)
    {
        return view('security.cameras.view', [
            'pageTitle' => 'Vista Cámara - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function alertas()
    {
        return view('security.alertas.index', [
            'pageTitle' => 'Alertas - UrbanOSS'
        ]);
    }
    
    public function resolveAlerta($id)
    {
        return back()->with('success', 'Alerta resuelta');
    }
}
