<?php
// ARCHIVO: app/Providers/AppServiceProvider.php
// VERSIÓN: 2.0 (UrbanOSS - Actualizado)
// DESCRIPCIÓN: Provider principal de la aplicación
// COMPATIBILIDAD: Laravel 11.47

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Registrar servicios de UrbanOSS
        $this->app->register(\App\Providers\UrbanOSSServiceProvider::class);
        
        // Bindings de modelos
        $this->app->bind(
            \App\Contracts\UserRepositoryInterface::class,
            \App\Repositories\UserRepository::class
        );
        
        $this->app->bind(
            \App\Contracts\CondominioRepositoryInterface::class,
            \App\Repositories\CondominioRepository::class
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Configurar longitud predeterminada de cadena para MySQL
        Schema::defaultStringLength(191);
        
        // Forzar HTTPS en producción
        if ($this->app->environment('production')) {
            URL::forceScheme('https');
        }
        
        // Usar Bootstrap para paginación
        Paginator::useBootstrap();
        
        // Configurar zona horaria
        date_default_timezone_set('America/Lima');
        
        // Configurar locale
        app()->setLocale('es');
        
        // Configuraciones globales para vistas
        view()->composer('*', function ($view) {
            $view->with('app_name', config('app.name', 'UrbanOSS'));
            $view->with('app_version', config('urbanoss.app.version', '1.0.0'));
            $view->with('current_year', date('Y'));
        });
    }
}