<?php
// ARCHIVO: #11 - config/roles.php
// VERSIÓN: UrbanOSS 2.0 - Laravel 11.47
// PREDECESORES: User.php (#1)
// RUTA EXACTA: config/roles.php
// REQUISITOS: Definición completa de roles y permisos
// FECHA: 2024-12-08

return [
    /*
    |--------------------------------------------------------------------------
    | ROLES DEL SISTEMA URBANOSS
    |--------------------------------------------------------------------------
    |
    | Definición completa de roles y sus permisos asociados.
    | Estructura jerárquica: superadmin > admin > propietario > inquilino > guardia
    |
    */

    'roles' => [
        'superadmin' => [
            'name' => 'Super Administrador',
            'description' => 'Control total de la plataforma, todos los condominios',
            'level' => 100,
            'dashboard_path' => '/admin/superadmin/dashboard',
            'icon' => 'shield-check',
            'color' => 'danger',
        ],
        
        'admin' => [
            'name' => 'Administrador de Condominio',
            'description' => 'Administra un condominio específico',
            'level' => 80,
            'dashboard_path' => '/admin/dashboard',
            'icon' => 'building',
            'color' => 'primary',
        ],
        
        'propietario' => [
            'name' => 'Propietario',
            'description' => 'Dueño de una o más unidades',
            'level' => 60,
            'dashboard_path' => '/resident/dashboard',
            'icon' => 'key',
            'color' => 'success',
        ],
        
        'inquilino' => [
            'name' => 'Inquilino',
            'description' => 'Residente temporal o arrendatario',
            'level' => 40,
            'dashboard_path' => '/resident/dashboard',
            'icon' => 'house-user',
            'color' => 'info',
        ],
        
        'guardia' => [
            'name' => 'Guardia de Seguridad',
            'description' => 'Personal de seguridad del condominio',
            'level' => 20,
            'dashboard_path' => '/security/dashboard',
            'icon' => 'shield',
            'color' => 'warning',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | PERMISOS POR MÓDULO
    |--------------------------------------------------------------------------
    */
    
    'permissions' => [
        // Módulo: Dashboard
        'dashboard' => [
            'view_superadmin_dashboard' => ['superadmin'],
            'view_admin_dashboard' => ['superadmin', 'admin'],
            'view_resident_dashboard' => ['superadmin', 'admin', 'propietario', 'inquilino'],
            'view_security_dashboard' => ['superadmin', 'admin', 'guardia'],
        ],

        // Módulo: Usuarios
        'users' => [
            'create_users' => ['superadmin', 'admin'],
            'view_users' => ['superadmin', 'admin'],
            'edit_users' => ['superadmin', 'admin'],
            'delete_users' => ['superadmin', 'admin'],
            'approve_users' => ['superadmin', 'admin'],
            'view_own_profile' => ['superadmin', 'admin', 'propietario', 'inquilino', 'guardia'],
            'edit_own_profile' => ['superadmin', 'admin', 'propietario', 'inquilino', 'guardia'],
        ],

        // Módulo: Condominios
        'condominios' => [
            'create_condominios' => ['superadmin'],
            'view_condominios' => ['superadmin', 'admin'],
            'edit_condominios' => ['superadmin', 'admin'],
            'delete_condominios' => ['superadmin'],
            'suspend_condominios' => ['superadmin'],
            'backup_condominios' => ['superadmin'],
        ],

        // Módulo: Unidades
        'unidades' => [
            'create_unidades' => ['superadmin', 'admin'],
            'view_unidades' => ['superadmin', 'admin', 'propietario'],
            'edit_unidades' => ['superadmin', 'admin'],
            'delete_unidades' => ['superadmin', 'admin'],
            'assign_unidades' => ['superadmin', 'admin'],
            'view_own_unidad' => ['propietario', 'inquilino'],
        ],

        // Módulo: Pagos
        'pagos' => [
            'create_pagos' => ['superadmin', 'admin'],
            'view_pagos' => ['superadmin', 'admin', 'propietario'],
            'edit_pagos' => ['superadmin', 'admin'],
            'delete_pagos' => ['superadmin', 'admin'],
            'approve_pagos' => ['superadmin', 'admin'],
            'pay_online' => ['propietario', 'inquilino'],
            'view_own_pagos' => ['propietario', 'inquilino'],
            'upload_payment_proof' => ['propietario', 'inquilino'],
        ],

        // Módulo: Áreas Comunes
        'areas_comunes' => [
            'manage_areas' => ['superadmin', 'admin'],
            'view_areas' => ['superadmin', 'admin', 'propietario', 'inquilino'],
            'reserve_areas' => ['superadmin', 'admin', 'propietario', 'inquilino'],
            'approve_reservations' => ['superadmin', 'admin'],
        ],

        // Módulo: Seguridad
        'seguridad' => [
            'manage_accesos' => ['superadmin', 'admin', 'guardia'],
            'view_accesos' => ['superadmin', 'admin', 'guardia'],
            'register_visitors' => ['superadmin', 'admin', 'guardia'],
            'view_cameras' => ['superadmin', 'admin', 'guardia', 'propietario', 'inquilino'],
            'manage_cameras' => ['superadmin', 'admin'],
        ],

        // Módulo: Notificaciones
        'notificaciones' => [
            'send_notifications' => ['superadmin', 'admin'],
            'view_notifications' => ['superadmin', 'admin', 'propietario', 'inquilino', 'guardia'],
            'delete_notifications' => ['superadmin', 'admin'],
        ],

        // Módulo: Reportes
        'reportes' => [
            'view_financial_reports' => ['superadmin', 'admin'],
            'view_operational_reports' => ['superadmin', 'admin'],
            'view_security_reports' => ['superadmin', 'admin', 'guardia'],
            'export_reports' => ['superadmin', 'admin'],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | RUTAS POR ROL
    |--------------------------------------------------------------------------
    */
    
    'routes' => [
        'superadmin' => [
            'allowed' => ['admin/*', 'resident/*', 'security/*', 'api/*'],
            'denied' => [],
            'redirect_if_unauthorized' => '/admin/superadmin/dashboard',
        ],
        
        'admin' => [
            'allowed' => ['admin/*', 'resident/*', 'security/*'],
            'denied' => ['admin/superadmin/*'],
            'redirect_if_unauthorized' => '/admin/dashboard',
        ],
        
        'propietario' => [
            'allowed' => ['resident/*', 'payments/*', 'reservations/*'],
            'denied' => ['admin/*', 'security/*'],
            'redirect_if_unauthorized' => '/resident/dashboard',
        ],
        
        'inquilino' => [
            'allowed' => ['resident/*', 'payments/*', 'reservations/*'],
            'denied' => ['admin/*', 'security/*', 'resident/units/edit'],
            'redirect_if_unauthorized' => '/resident/dashboard',
        ],
        
        'guardia' => [
            'allowed' => ['security/*', 'cameras/*'],
            'denied' => ['admin/*', 'resident/*'],
            'redirect_if_unauthorized' => '/security/dashboard',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | CONFIGURACIÓN AVANZADA
    |--------------------------------------------------------------------------
    */
    
    'hierarchical' => true, // Los roles superiores heredan permisos de inferiores
    
    'default_role' => 'propietario',
    
    'registration_default_role' => 'propietario',
    
    'role_colors' => [
        'superadmin' => '#dc2626', // rojo
        'admin' => '#2563eb', // azul
        'propietario' => '#059669', // verde
        'inquilino' => '#0891b2', // cyan
        'guardia' => '#d97706', // ámbar
    ],
    
    'role_icons' => [
        'superadmin' => 'shield-check',
        'admin' => 'building',
        'propietario' => 'key',
        'inquilino' => 'house-user',
        'guardia' => 'shield',
    ],
];