<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Condominio;
use Illuminate\Support\Facades\DB;

class TestUsersSeeder extends Seeder
{
    public function run(): void
    {
        DB::beginTransaction();
        
        try {
            // 1. Asegurar que existe al menos un superadmin
            $superadmin = User::where('role', 'superadmin')->first();
            
            if (!$superadmin) {
                $superadmin = User::create([
                    'name' => 'Super Administrador',
                    'email' => 'superadmin@urbanoss.com',
                    'password' => Hash::make('SuperAdmin123'),
                    'role' => 'superadmin',
                    'estado' => 'activo',
                    'email_verified_at' => now(),
                ]);
            }
            
            // 2. Crear condominio usando el superadmin existente
            // Primero verificar si ya existe
            $condominio = Condominio::where('nombre', 'Condominio Las Palmeras')->first();
            
            if (!$condominio) {
                $condominio = Condominio::create([
                    'nombre' => 'Condominio Las Palmeras',
                    'direccion' => 'Av. Principal 123',
                    'ciudad' => 'Lima',
                    'telefono' => '+51 987654321',
                    'email' => 'info@laspalmeras.com',
                    'estado' => 'activo',
                    'superadministrador_id' => $superadmin->id,
                ]);
            }
            
            // 3. Crear otros usuarios
            $users = [
                ['admin@laspalmeras.com', 'Administrador', 'Admin123', 'admin', $condominio->id],
                ['propietario@laspalmeras.com', 'Juan Pérez', 'Propietario123', 'propietario', $condominio->id],
                ['inquilino@laspalmeras.com', 'María García', 'Inquilino123', 'inquilino', $condominio->id],
                ['guardia@laspalmeras.com', 'Carlos López', 'Guardia123', 'guardia', $condominio->id],
            ];
            
            foreach ($users as $user) {
                User::firstOrCreate(
                    ['email' => $user[0]],
                    [
                        'name' => $user[1],
                        'password' => Hash::make($user[2]),
                        'role' => $user[3],
                        'condominio_id' => $user[4],
                        'estado' => 'activo',
                        'email_verified_at' => now(),
                    ]
                );
            }
            
            DB::commit();
            
            $this->command->info('✅ Usuarios creados exitosamente!');
            $this->command->info('');
            $this->command->info('SUPERADMIN: superadmin@urbanoss.com / SuperAdmin123');
            $this->command->info('ADMIN: admin@laspalmeras.com / Admin123');
            $this->command->info('PROPIETARIO: propietario@laspalmeras.com / Propietario123');
            $this->command->info('INQUILINO: inquilino@laspalmeras.com / Inquilino123');
            $this->command->info('GUARDIA: guardia@laspalmeras.com / Guardia123');
            
        } catch (\Exception $e) {
            DB::rollBack();
            $this->command->error('Error: ' . $e->getMessage());
            throw $e;
        }
    }
}
