<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>UrbanOSS Debug</h1>";

// 1. Verificar Laravel
try {
    require __DIR__.'/../vendor/autoload.php';
    echo "<p style='color:green'>✅ vendor/autoload.php cargado</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Error cargando autoload: " . $e->getMessage() . "</p>";
    exit;
}

// 2. Verificar aplicación Laravel
try {
    $app = require_once __DIR__.'/../bootstrap/app.php';
    echo "<p style='color:green'>✅ bootstrap/app.php cargado</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Error en bootstrap: " . $e->getMessage() . "</p>";
    exit;
}

// 3. Verificar controladores
$controllers = [
    'App\Http\Controllers\Auth\LoginController',
    'App\Http\Controllers\Auth\RegisterController',
    'App\Http\Controllers\Admin\SuperAdminController',
];

foreach ($controllers as $controller) {
    if (class_exists($controller)) {
        echo "<p style='color:green'>✅ $controller existe</p>";
    } else {
        echo "<p style='color:red'>❌ $controller NO existe</p>";
    }
}

// 4. Verificar middleware
$middlewares = [
    'App\Http\Middleware\EncryptCookies',
    'App\Http\Middleware\VerifyCsrfToken',
    'App\Http\Middleware\Authenticate',
    'App\Http\Middleware\CheckRole',
];

foreach ($middlewares as $middleware) {
    if (class_exists($middleware)) {
        echo "<p style='color:green'>✅ $middleware existe</p>";
    } else {
        echo "<p style='color:red'>❌ $middleware NO existe</p>";
    }
}

// 5. Verificar rutas
try {
    $kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
    $response = $kernel->handle(
        $request = Illuminate\Http\Request::capture()
    );
    echo "<p style='color:green'>✅ Kernel cargado correctamente</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Error en kernel: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr><h3>Variables de entorno:</h3>";
echo "<pre>APP_ENV: " . ($_ENV['APP_ENV'] ?? 'No definido') . "</pre>";
echo "<pre>APP_DEBUG: " . ($_ENV['APP_DEBUG'] ?? 'No definido') . "</pre>";
