<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $pageTitle ?? 'Dashboard SuperAdmin - UrbanOSS' }}</title>
    
    <!-- Favicon -->
    <link rel="icon" href="{{ url('/favicon.ico') }}" type="image/x-icon">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            600: '#2563eb',
                            700: '#1d4ed8',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .sidebar {
            transition: all 0.3s ease;
        }
        .stat-card {
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navbar Superior -->
    <nav class="bg-white shadow-sm border-b">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center py-3">
                <!-- Logo y título -->
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-primary-600 rounded-lg flex items-center justify-center">
                        <i class="fas fa-building text-white"></i>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold text-gray-800">
                            Urban<span class="text-primary-600">OSS</span>
                        </h1>
                        <p class="text-xs text-gray-500">SuperAdmin Dashboard</p>
                    </div>
                </div>
                
                <!-- Menú usuario -->
                <div class="relative">
                    <button id="userMenuButton" class="flex items-center space-x-2 focus:outline-none">
                        <div class="w-8 h-8 bg-primary-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-user text-primary-600"></i>
                        </div>
                        <span class="text-gray-700">{{ auth()->user()->name }}</span>
                        <i class="fas fa-chevron-down text-gray-500 text-sm"></i>
                    </button>
                    
                    <!-- Dropdown menu -->
                    <div id="userMenu" class="hidden absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-1 border">
                        <div class="px-4 py-2 border-b">
                            <p class="text-sm font-medium text-gray-800">{{ auth()->user()->name }}</p>
                            <p class="text-xs text-gray-500">{{ auth()->user()->email }}</p>
                            <p class="text-xs text-primary-600 font-medium mt-1">
                                {{ ucfirst(auth()->user()->role) }}
                            </p>
                        </div>
                        <div class="py-1">
                            <a href="{{ route('profile.edit') }}" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-user-circle mr-3 text-gray-400"></i>
                                Mi Perfil
                            </a>
                            <a href="{{ route('settings') }}" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-cog mr-3 text-gray-400"></i>
                                Configuración
                            </a>
                        </div>
                        <div class="py-1 border-t border-gray-200">
                            <form method="POST" action="{{ route('logout') }}" class="w-full">
                                @csrf
                                <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                    <i class="fas fa-sign-out-alt mr-3"></i>
                                    Cerrar Sesión
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Contenido principal -->
    <div class="container mx-auto px-4 py-8">
        <!-- Header -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold text-gray-800">Dashboard SuperAdmin</h2>
            <p class="text-gray-600">Panel de control global del sistema</p>
        </div>
        
        <!-- Estadísticas -->
        @if(isset($stats) && count($stats) > 0)
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div class="stat-card bg-white p-6 rounded-xl shadow-sm border">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Total Condominios</p>
                        <p class="text-2xl font-bold text-gray-800">{{ $stats['totalCondominios'] ?? 0 }}</p>
                    </div>
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-building text-blue-600"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card bg-white p-6 rounded-xl shadow-sm border">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Condominios Activos</p>
                        <p class="text-2xl font-bold text-green-600">{{ $stats['activeCondominios'] ?? 0 }}</p>
                    </div>
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-check-circle text-green-600"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card bg-white p-6 rounded-xl shadow-sm border">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Total Usuarios</p>
                        <p class="text-2xl font-bold text-gray-800">{{ $stats['totalUsers'] ?? 0 }}</p>
                    </div>
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-users text-purple-600"></i>
                    </div>
                </div>
            </div>
            
            <div class="stat-card bg-white p-6 rounded-xl shadow-sm border">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Usuarios Pendientes</p>
                        <p class="text-2xl font-bold text-yellow-600">{{ $stats['pendingUsers'] ?? 0 }}</p>
                    </div>
                    <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-clock text-yellow-600"></i>
                    </div>
                </div>
            </div>
        </div>
        @else
        <div class="bg-white p-6 rounded-xl shadow-sm border mb-8">
            <div class="text-center py-8">
                <i class="fas fa-chart-bar text-4xl text-gray-300 mb-4"></i>
                <p class="text-gray-500">No hay estadísticas disponibles</p>
                @if(isset($error))
                <p class="text-red-500 text-sm mt-2">{{ $error }}</p>
                @endif
            </div>
        </div>
        @endif
        
        <!-- Acciones rápidas -->
        <div class="grid md:grid-cols-3 gap-6">
            <a href="{{ route('superadmin.administrators.index') }}" 
               class="bg-white p-6 rounded-xl shadow-sm border hover:shadow-md transition">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-user-shield text-blue-600"></i>
                    </div>
                    <div>
                        <h3 class="font-medium text-gray-800">Administradores</h3>
                        <p class="text-sm text-gray-500">Gestionar administradores</p>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('superadmin.reports.financial') }}" 
               class="bg-white p-6 rounded-xl shadow-sm border hover:shadow-md transition">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-chart-line text-green-600"></i>
                    </div>
                    <div>
                        <h3 class="font-medium text-gray-800">Reportes</h3>
                        <p class="text-sm text-gray-500">Ver reportes financieros</p>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('superadmin.settings') }}" 
               class="bg-white p-6 rounded-xl shadow-sm border hover:shadow-md transition">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-cogs text-purple-600"></i>
                    </div>
                    <div>
                        <h3 class="font-medium text-gray-800">Configuración</h3>
                        <p class="text-sm text-gray-500">Ajustes del sistema</p>
                    </div>
                </div>
            </a>
        </div>
        
        <!-- Información del sistema -->
        <div class="mt-8 bg-white p-6 rounded-xl shadow-sm border">
            <h3 class="font-medium text-gray-800 mb-4">Información del Sistema</h3>
            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <p class="text-sm text-gray-500">Versión UrbanOSS</p>
                    <p class="font-medium">3.1 - Laravel 11.47</p>
                </div>
                <div>
                    <p class="text-sm text-gray-500">URL del Sistema</p>
                    <p class="font-medium">{{ config('app.url') }}</p>
                </div>
                <div>
                    <p class="text-sm text-gray-500">Fecha y Hora</p>
                    <p class="font-medium">{{ now()->format('d/m/Y H:i:s') }}</p>
                </div>
                <div>
                    <p class="text-sm text-gray-500">Estado</p>
                    <span class="inline-flex items-center text-green-600 font-medium">
                        <span class="w-2 h-2 bg-green-500 rounded-full mr-2"></span>
                        Operativo
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Menú de usuario
            const userMenuButton = document.getElementById('userMenuButton');
            const userMenu = document.getElementById('userMenu');
            
            if (userMenuButton && userMenu) {
                userMenuButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    userMenu.classList.toggle('hidden');
                });
                
                // Cerrar menú al hacer click fuera
                document.addEventListener('click', function(e) {
                    if (!userMenu.contains(e.target) && !userMenuButton.contains(e.target)) {
                        userMenu.classList.add('hidden');
                    }
                });
            }
            
            // Prevenir envío múltiple de formularios
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                let isSubmitting = false;
                form.addEventListener('submit', function(e) {
                    if (isSubmitting) {
                        e.preventDefault();
                        return;
                    }
                    isSubmitting = true;
                    
                    // Mostrar loading en botones de submit
                    const submitBtn = form.querySelector('button[type="submit"]');
                    if (submitBtn) {
                        const originalText = submitBtn.innerHTML;
                        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Procesando...';
                        submitBtn.disabled = true;
                        
                        // Restaurar después de 5 segundos por si hay error
                        setTimeout(() => {
                            submitBtn.innerHTML = originalText;
                            submitBtn.disabled = false;
                            isSubmitting = false;
                        }, 5000);
                    }
                });
            });
        });
    </script>
</body>
</html>
