<?php
// ARCHIVO: routes/favicon.php
// VERSIÓN: UrbanOSS 3.1 - Laravel 11.47
// FECHA: 2024-12-08
// PROPÓSITO: Ruta específica para servir favicon.ico sin errores

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Response;

// Ruta específica para favicon.ico
Route::get('/favicon.ico', function () {
    $faviconPaths = [
        public_path('favicon.ico'),
        public_path('images/favicon.ico'),
        public_path('img/favicon.ico'),
        base_path('public/favicon.ico'),
    ];
    
    // Buscar favicon en diferentes ubicaciones
    foreach ($faviconPaths as $path) {
        if (file_exists($path)) {
            return response()->file($path, [
                'Content-Type' => 'image/x-icon',
                'Cache-Control' => 'public, max-age=31536000, immutable',
            ]);
        }
    }
    
    // Si no existe favicon, crear uno temporal en memoria
    $svg = '<?xml version="1.0" encoding="UTF-8"?>
    <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg">
        <rect width="64" height="64" fill="#2563eb"/>
        <rect x="12" y="20" width="40" height="28" rx="3" fill="#ffffff"/>
        <rect x="18" y="26" width="8" height="8" rx="1" fill="#1e40af"/>
        <rect x="30" y="26" width="8" height="8" rx="1" fill="#1e40af"/>
        <rect x="18" y="38" width="8" height="8" rx="1" fill="#1e40af"/>
        <rect x="30" y="38" width="8" height="8" rx="1" fill="#1e40af"/>
        <rect x="22" y="28" width="4" height="4" fill="#ffffff"/>
        <rect x="34" y="28" width="4" height="4" fill="#ffffff"/>
        <rect x="22" y="40" width="4" height="4" fill="#ffffff"/>
        <rect x="34" y="40" width="4" height="4" fill="#ffffff"/>
        <rect x="26" y="48" width="12" height="8" rx="2" fill="#0f2847"/>
        <rect x="30" y="50" width="4" height="4" fill="#ffffff"/>
    </svg>';
    
    return response($svg, 200)
        ->header('Content-Type', 'image/svg+xml')
        ->header('Cache-Control', 'public, max-age=86400');
})->name('favicon');