<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UrbanOSS - Sistema de Administración de Condominios</title>
    
    <!-- Favicon corregido -->
    <link rel="icon" href="<?php echo e(url('/favicon.ico')); ?>?v=3" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo e(url('/favicon.ico')); ?>?v=3" type="image/x-icon">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            600: '#2563eb',
                            700: '#1d4ed8',
                        },
                        secondary: {
                            50: '#f8fafc',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        .hero-gradient {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
        }
        .feature-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="font-sans antialiased">
    <!-- Navigation -->
    <nav class="bg-white shadow-sm">
        <div class="container mx-auto px-4 py-3">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-primary-600 rounded-lg flex items-center justify-center">
                        <i class="fas fa-building text-white text-xl"></i>
                    </div>
                    <span class="text-xl font-bold text-gray-800">
                        Urban<span class="text-primary-600">OSS</span>
                    </span>
                </div>
                
                <div class="hidden md:flex items-center space-x-6">
                    <a href="<?php echo e(route('login')); ?>" 
                       class="bg-primary-600 text-white px-5 py-2 rounded-lg hover:bg-primary-700 transition">
                        <i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-gradient text-white py-16">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-4xl md:text-5xl font-bold mb-6">
                Bienvenido a <span class="text-yellow-300">UrbanOSS</span>
            </h1>
            <p class="text-xl mb-10 max-w-2xl mx-auto">
                Sistema integral de administración de condominios
            </p>
            
            <div class="flex flex-col md:flex-row justify-center gap-4">
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('dashboard')); ?>" 
                       class="bg-white text-primary-600 px-8 py-3 rounded-lg text-lg font-semibold hover:bg-gray-50 transition inline-flex items-center justify-center">
                        <i class="fas fa-tachometer-alt mr-2"></i>Ir al Panel
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" 
                       class="bg-white text-primary-600 px-8 py-3 rounded-lg text-lg font-semibold hover:bg-gray-50 transition inline-flex items-center justify-center">
                        <i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Features -->
    <section class="py-16 bg-secondary-50">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12 text-gray-800">
                Características Principales
            </h2>
            
            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white p-6 rounded-xl feature-card">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-money-bill-wave text-primary-600 text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Gestión de Pagos</h3>
                    <p class="text-gray-600">
                        Control completo de cobros, recibos digitales y reportes financieros.
                    </p>
                </div>
                
                <div class="bg-white p-6 rounded-xl feature-card">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-shield-alt text-green-600 text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Control de Acceso</h3>
                    <p class="text-gray-600">
                        Sistema de seguridad integrado con registro de visitas y vigilancia.
                    </p>
                </div>
                
                <div class="bg-white p-6 rounded-xl feature-card">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-calendar-check text-purple-600 text-xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Reservas Inteligentes</h3>
                    <p class="text-gray-600">
                        Gestión de áreas comunes con calendario interactivo.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="py-16 bg-gray-800 text-white">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-3xl font-bold mb-6">
                ¿Necesitas ayuda?
            </h2>
            <p class="text-lg mb-8 max-w-xl mx-auto">
                Nuestro equipo de soporte está disponible para resolver tus consultas.
            </p>
            <div class="inline-flex flex-col items-center">
                <a href="mailto:soporte@urbanoss.com" 
                   class="bg-primary-600 text-white px-6 py-3 rounded-lg hover:bg-primary-700 transition mb-3">
                    <i class="fas fa-envelope mr-2"></i>soporte@urbanoss.com
                </a>
                <p class="text-gray-300 text-sm">
                    <i class="fas fa-phone mr-2"></i>+51 123 456 789
                </p>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-8">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row justify-between items-center">
                <div class="mb-6 md:mb-0">
                    <div class="flex items-center space-x-2 mb-3">
                        <div class="w-8 h-8 bg-primary-600 rounded flex items-center justify-center">
                            <i class="fas fa-building text-white"></i>
                        </div>
                        <span class="text-lg font-bold">UrbanOSS</span>
                    </div>
                    <p class="text-gray-400 text-sm">
                        © <?php echo e(date('Y')); ?> UrbanOSS. Todos los derechos reservados.
                    </p>
                    <p class="text-gray-500 text-xs mt-1">
                        Versión 3.1 - Laravel 11.47
                    </p>
                </div>
                
                <div class="flex space-x-6">
                    <a href="#" class="text-gray-400 hover:text-white text-sm">
                        Términos
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white text-sm">
                        Privacidad
                    </a>
                </div>
            </div>
            
            <div class="mt-8 pt-8 border-t border-gray-800 text-center">
                <div class="inline-flex items-center text-green-400 text-sm">
                    <span class="w-2 h-2 bg-green-500 rounded-full mr-2 animate-pulse"></span>
                    Sistema operativo
                    <a href="/health" class="ml-2 text-gray-400 hover:text-white text-xs">
                        Ver estado
                    </a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script>
        // Verificar favicon
        document.addEventListener('DOMContentLoaded', function() {
            const favicon = document.querySelector('link[rel="icon"]');
            if (favicon) {
                console.log('Favicon configurado en:', favicon.href);
                
                // Forzar recarga del favicon
                const img = new Image();
                img.src = favicon.href;
                img.onload = () => console.log('Favicon cargado');
                img.onerror = () => {
                    console.log('Usando favicon por defecto');
                    favicon.href = 'data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>🏢</text></svg>';
                };
            }
            
            // Verificar autenticación
            fetch('/check-auth')
                .then(res => res.json())
                .then(data => {
                    if (data.authenticated) {
                        console.log('Usuario autenticado:', data.user?.email);
                    }
                })
                .catch(() => console.log('No autenticado'));
        });
    </script>
</body>
</html>
[file content end]<?php /**PATH /home/urbanoss/public_html/plataforma/resources/views/welcome.blade.php ENDPATH**/ ?>