/** @type {import('tailwindcss').Config} */
export default {
    content: [
        "./resources/**/*.blade.php",
        "./resources/**/*.js",
        "./storage/framework/views/*.php",
        "./app/Http/Livewire/**/*.php",
    ],
    darkMode: 'class',
    theme: {
        extend: {
            colors: {
                // Paleta UrbanOSS - Manteniendo tus variables
                'urbanoss': {
                    primary: '#1e3a5f',
                    'primary-50': '#f0f4f8',
                    'primary-100': '#d9e2ec',
                    'primary-200': '#bcccdc',
                    'primary-300': '#9fb3c8',
                    'primary-400': '#829ab1',
                    'primary-500': '#1e3a5f',
                    'primary-600': '#0f2847',
                    'primary-700': '#0a1f3a',
                    'primary-800': '#06162d',
                    'primary-900': '#030d1f',
                    
                    secondary: '#2563eb',
                    'secondary-50': '#eff6ff',
                    'secondary-100': '#dbeafe',
                    'secondary-200': '#bfdbfe',
                    'secondary-300': '#93c5fd',
                    'secondary-400': '#60a5fa',
                    'secondary-500': '#3b82f6',
                    'secondary-600': '#2563eb',
                    'secondary-700': '#1d4ed8',
                    'secondary-800': '#1e40af',
                    'secondary-900': '#1e3a8a',
                    
                    success: '#059669',
                    'success-light': '#10b981',
                    'success-dark': '#047857',
                    
                    warning: '#d97706',
                    'warning-light': '#f59e0b',
                    'warning-dark': '#b45309',
                    
                    danger: '#dc2626',
                    'danger-light': '#ef4444',
                    'danger-dark': '#b91c1c',
                    
                    info: '#0891b2',
                    'info-light': '#06b6d4',
                    'info-dark': '#0e7490',
                    
                    light: '#f8fafc',
                    'light-gray': '#e2e8f0',
                    gray: '#94a3b8',
                    'dark-gray': '#475569',
                    white: '#ffffff',
                    black: '#1e293b',
                }
            },
            fontFamily: {
                'sans': ['Inter', 'system-ui', '-apple-system', 'sans-serif'],
                'heading': ['Montserrat', 'Inter', 'sans-serif'],
            },
            spacing: {
                'xs': '0.25rem',
                'sm': '0.5rem',
                'md': '1.5rem',
                'lg': '2rem',
                'xl': '3rem',
                '2xl': '4rem',
            },
            borderRadius: {
                'sm': '0.375rem',
                'md': '0.75rem',
                'lg': '1rem',
                'xl': '1.5rem',
                'full': '9999px',
            },
            boxShadow: {
                'urbanoss-sm': '0 1px 2px 0 rgba(0, 0, 0, 0.05)',
                'urbanoss': '0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)',
                'urbanoss-md': '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
                'urbanoss-lg': '0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05)',
                'urbanoss-xl': '0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04)',
                'urbanoss-inner': 'inset 0 2px 4px 0 rgba(0, 0, 0, 0.06)',
            },
            animation: {
                'fade-in': 'fadeIn 0.3s ease-out',
                'slide-up': 'slideInUp 0.3s ease-out',
                'slide-down': 'slideInDown 0.3s ease-out',
                'slide-left': 'slideInLeft 0.3s ease-out',
                'slide-right': 'slideInRight 0.3s ease-out',
                'pulse': 'pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                'spin': 'spin 1s linear infinite',
            },
            keyframes: {
                fadeIn: {
                    'from': { opacity: '0' },
                    'to': { opacity: '1' }
                },
                slideInUp: {
                    'from': { transform: 'translateY(20px)', opacity: '0' },
                    'to': { transform: 'translateY(0)', opacity: '1' }
                },
                slideInDown: {
                    'from': { transform: 'translateY(-20px)', opacity: '0' },
                    'to': { transform: 'translateY(0)', opacity: '1' }
                },
                slideInLeft: {
                    'from': { transform: 'translateX(-20px)', opacity: '0' },
                    'to': { transform: 'translateX(0)', opacity: '1' }
                },
                slideInRight: {
                    'from': { transform: 'translateX(20px)', opacity: '0' },
                    'to': { transform: 'translateX(0)', opacity: '1' }
                },
                spin: {
                    'from': { transform: 'rotate(0deg)' },
                    'to': { transform: 'rotate(360deg)' }
                },
                pulse: {
                    '0%, 100%': { opacity: '1' },
                    '50%': { opacity: '0.5' }
                }
            }
        },
    },
    plugins: [
        require('@tailwindcss/forms'),
    ],
};