<?php
// ARCHIVO: tests/Unit/UserModelTest.php (Opcional para verificación)
// EJECUCIÓN: php artisan test --filter UserModelTest

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\User;

class UserModelTest extends TestCase
{
    public function test_superadmin_user()
    {
        $user = User::find(1);
        $this->assertTrue($user->isSuperAdmin());
        $this->assertEquals('Super Administrador de Plataforma', $user->getWelcomeMessage());
    }
    
    public function test_whatsapp_functionality()
    {
        $user = new User(['whatsapp' => '+51987654321']);
        $this->assertEquals('51987654321', $user->getWhatsAppNumber());
    }
}